
clear; clc; 

WhereAreWe = cd; 

path(path,[WhereAreWe '\Data']);
path(path,[WhereAreWe '\Subcodes']);


CaseToPlot = 'Total Loans To GDP'; 
% CaseToPlot = 'HH Loans To GDP';         % Household Debt to GDP  
% CaseToPlot = 'CC Loans To GDP';         % Corporate Debt to GDP

UseFilterOrNot = 'Use Filter'; 

WhichFrequency = 'QoQ'; 

switch UseFilterOrNot
    case 'No Filter'
    WhereToSaveFigures = [WhereAreWe '\Save_Figures'];
    case 'Use Filter'
    WhereToSaveFigures = [WhereAreWe '\Save_FiguresFilter'];
end

if WhichFrequency == 'YoY'
    WhereToSaveFigures = [WhereAreWe '\Save_FiguresYoY'];
end    
    
    
%% STRUCTURE DATASET (JTS)

% 1	year	Year
% 2	country	Country
% 3	iso	ISO 3-letter code
% 4	ifs	IFS 3-number country-code
% 5	pop	Population
% 6	rgdpmad	Real GDP per capita (PPP)
% 7	rgdppc	Real GDP per capita (index, 2005=100)
% 8	rconpc	Real consumption per capita (index, 2006=100)
% 9	gdp	GDP (nominal, local currency)
% 10	iy	Investment-to-GDP ratio
% 11	cpi	Consumer prices (index, 1990=100)
% 12	ca	Current account (nominal, local currency)
% 13	imports	Imports (nominal, local currency)
% 14	exports	Exports (nominal, local currency)
% 15	narrowm	Narrow money (nominal, local currency)
% 16	money	Broad money (nominal, local currency)
% 17	stir	Short-term interest rate (nominal, percent per year)
% 18	ltrate	Long-term interest rate (nominal, percent per year)
% 19	stocks	Stock prices (nominal index)
% 20	debtgdp	Public debt-to-GDP ratio
% 21	revenue	Government revenues (nominal, local currency)
% 22	expenditure	Government expenditure (nominal, local currency)
% 23	xrusd	USD exchange rate (local currency/USD)
% 24	crisisJST	Systemic financial crises (0-1 dummy)
% 25	tloans	Total loans to non-financial private sector (nominal, local currency)
% 26	tmort	Mortgage loans to non-financial private sector (nominal, local currency)
% 27	thh	Total loans to households (nominal, local currency)
% 28	tbus	Total loans to business (nominal, local currency)
% 29	hpnom	House prices (nominal index, 1990=100)

%% 

[RawData,~,RawDataArray] = xlsread('JSTdatasetR2_G7.xlsx','Data','A2:AC1009'); 

YEARS = RawData(:,1);
COUNTRY_NAMES = RawDataArray(:,3);
NOMINAL_GDP = RawData(:,9);
TOTAL_LOANS = RawData(:,25);
TOTAL_HH_LOANS = RawData(:,27);
TOTAL_CC_LOANS = RawData(:,28);
REAL_GDPPC = RawData(:,7);

AllDATA = [YEARS NOMINAL_GDP TOTAL_LOANS TOTAL_HH_LOANS TOTAL_CC_LOANS REAL_GDPPC];

StartYear = 1961; 
SplitYear = 1985; 
LastYear = max(YEARS); 

YearsLag = 8; 

UniqueCountries = unique(COUNTRY_NAMES,'stable');

for country = 1:size(UniqueCountries,1)
    
    SelectCountry = strcmp(COUNTRY_NAMES,UniqueCountries(country,1));
    Country_DATA = AllDATA(SelectCountry,:);
    
    StartData = find(Country_DATA(:,1)==StartYear);
    EndData = find(Country_DATA(:,1)==LastYear);
    Country_DATA(:,end) = [NaN; log(Country_DATA(2:end,end))-log(Country_DATA(1:end-1,end))];
    
    Country_DATA = Country_DATA(StartData-YearsLag:EndData,:);
    YEARS_Used = YEARS(StartData-YearsLag:EndData,:);
    GDPgrowth = Country_DATA(:,end); 

    
    switch CaseToPlot
        case 'Total Loans To GDP'
            LoanToGDP = Country_DATA(:,3)./Country_DATA(:,2);
        case 'HH Loans To GDP'
            LoanToGDP = Country_DATA(:,4)./Country_DATA(:,2);
        case 'CC Loans To GDP'
            LoanToGDP = Country_DATA(:,5)./Country_DATA(:,2);
    end

        for tt = YearsLag:size(Country_DATA,1)
        LtGDP(tt-YearsLag+1,country) = mean(LoanToGDP(tt-YearsLag+1:tt,1));
        YEARS_Used2(tt-YearsLag+1,country) = YEARS_Used(tt,1);
        end
            
end


switch UseFilterOrNot
    case 'Use Filter'
        load saveRollingData_International
    case 'No Filter'
        load saveRollingData_International_Nofilter
end


switch WhichFrequency
    case 'QoQ'
        Skewness = SkewnessPanelQoQ; 
        RationPosNegSemiVar = RelativeVariancePanelQoQ; 
    case 'YoY'
        Skewness = SkewnessPanelYoY; 
        RationPosNegSemiVar = RelativeVariancePanelYoY;
end


%%

CountryDummy1 = zeros(size(Skewness)); CountryDummy1(:,1)=1; 
CountryDummy2 = zeros(size(Skewness)); CountryDummy2(:,2)=1; 
CountryDummy3 = zeros(size(Skewness)); CountryDummy3(:,3)=1; 
CountryDummy4 = zeros(size(Skewness)); CountryDummy4(:,4)=1; 
CountryDummy5 = zeros(size(Skewness)); CountryDummy5(:,5)=1; 
CountryDummy6 = zeros(size(Skewness)); CountryDummy6(:,6)=1; 
Constant = ones(size(Skewness));



%% Figure Ratio of Semivariances
Y = RationPosNegSemiVar(:); 
Z = [CountryDummy1(:) CountryDummy2(:) CountryDummy3(:) CountryDummy4(:) CountryDummy5(:) CountryDummy6(:)]; 
X = LtGDP(:);

Select=isfinite(sum([Y X],2));
NamesYX{1} = 'Loans/GDP'; NamesYX{2} = '\sigma^{-}/\sigma^{+}';
% [BinsX,BinsY,BinsFitY]=binscatterplot(Y(Select,:),X(Select,:),Z(Select,:),30,2,1,NamesYX);
% [BinsX,BinsY,BinsFitY]=binscatterplot(Y(Select,:),X(Select,:),Z(Select,:),sum(Select),2,1,NamesYX);
[BinsX,BinsY,BinsFitY]=binscatterplotOUTLIERcorrect(Y(Select,:),X(Select,:),Z(Select,:),30,2,1,NamesYX);
% [BinsX,BinsY,BinsFitY]=binscatterplotOUTLIERcorrect(Y(Select,:),X(Select,:),Z(Select,:),sum(Select),2,1,NamesYX);
tightfig;

    switch CaseToPlot
        case 'Total Loans To GDP'
            saveas(gcf,[WhereToSaveFigures '\Plot_G7_SemiVarianceRatio.pdf']);
            saveas(gcf,[WhereToSaveFigures '\Plot_G7_SemiVarianceRatio.tif']);
        case 'HH Loans To GDP'
            saveas(gcf,[WhereToSaveFigures '\Plot_G7_SemiVarianceRatio_HH.pdf']);
            saveas(gcf,[WhereToSaveFigures '\Plot_G7_SemiVarianceRatio_HH.tif']);
        case 'CC Loans To GDP'
            saveas(gcf,[WhereToSaveFigures '\Plot_G7_SemiVarianceRatio_CC.pdf']);
            saveas(gcf,[WhereToSaveFigures '\Plot_G7_SemiVarianceRatio_CC.tif']);
    end

    

%% Figure Ratio of Skewness
Y = Skewness(:); 
Z = [CountryDummy1(:) CountryDummy2(:) CountryDummy3(:) CountryDummy4(:) CountryDummy5(:) CountryDummy6(:)]; 
X = LtGDP(:);

Select=isfinite(sum([Y X],2));
NamesYX{1} = 'Loans/GDP'; NamesYX{2} = 'Skewness';
% [BinsX,BinsY,BinsFitY]=binscatterplot(Y(Select,:),X(Select,:),Z(Select,:),30,2,1,NamesYX);
% [BinsX,BinsY,BinsFitY]=binscatterplot(Y(Select,:),X(Select,:),Z(Select,:),sum(Select),2,1,NamesYX);
[BinsX,BinsY,BinsFitY]=binscatterplotOUTLIERcorrect(Y(Select,:),X(Select,:),Z(Select,:),30,2,1,NamesYX);
% [BinsX,BinsY,BinsFitY]=binscatterplotOUTLIERcorrect(Y(Select,:),X(Select,:),Z(Select,:),sum(Select),2,1,NamesYX);
tightfig;

    switch CaseToPlot
        case 'Total Loans To GDP'
            saveas(gcf,[WhereToSaveFigures '\Plot_G7_Skewness.pdf']);
            saveas(gcf,[WhereToSaveFigures '\Plot_G7_Skewness.tif']);
        case 'HH Loans To GDP'
            saveas(gcf,[WhereToSaveFigures '\Plot_G7_Skewness_HH.pdf']);
            saveas(gcf,[WhereToSaveFigures '\Plot_G7_Skewness_HH.tif']);
        case 'CC Loans To GDP'
            saveas(gcf,[WhereToSaveFigures '\Plot_G7_Skewness_CC.pdf']);
            saveas(gcf,[WhereToSaveFigures '\Plot_G7_Skewness_CC.tif']);
    end
    
    
    